/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import lotr.common.util.LOTRPacketMoneyChange;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.DimensionManager;

public class LOTRPlayerMoneyData {
    public static File ROOT;
    public static File ROOT_PD;
    public static final Map<String, LOTRPlayerMoneyData> server_cache;
    private static LOTRPlayerMoneyData client_cache;
    public final UUID uuid;
    public final String name;
    public boolean enabled = true;
    public int money = 0;

    public static void setRoots() {
        ROOT = LOTRPlayerMoneyData.folder(DimensionManager.getCurrentSaveRootDirectory(), "LOTR");
        ROOT_PD = LOTRPlayerMoneyData.folder(ROOT, "moneydata");
    }

    private static File folder(File parent, String name) {
        File ret = new File(parent, name);
        if (!ret.exists()) {
            ret.mkdirs();
        }
        return ret;
    }

    public void updateBalance(EntityPlayerMP player) {
        this.sendUpdatedBalance(player);
    }

    public void sendUpdatedBalance(EntityPlayerMP player) {
        LOTRPacketMoneyChange packet = new LOTRPacketMoneyChange(this.money);
        packet.sendTo(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LOTRPlayerMoneyData of(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            String _name = player.func_70005_c_();
            return server_cache.computeIfAbsent(_name, name -> {
                LOTRPlayerMoneyData data = new LOTRPlayerMoneyData(player.func_146103_bH().getId(), player.func_70005_c_());
                data.readFromFile();
                return data;
            });
        }
        Class<LOTRPlayerMoneyData> clazz = LOTRPlayerMoneyData.class;
        synchronized (LOTRPlayerMoneyData.class) {
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return client_cache != null ? client_cache : (client_cache = new LOTRPlayerMoneyData(player.func_146103_bH().getId(), player.func_146103_bH().getName()));
        }
    }

    public void setMoney(int money, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            this.money = money;
            LOTRPacketMoneyChange packet = new LOTRPacketMoneyChange(this.money);
            packet.sendTo((EntityPlayerMP)player);
        }
    }

    public static void saveAll() {
        server_cache.values().forEach(LOTRPlayerMoneyData::writeToFile);
    }

    public static void quit() {
        LOTRPlayerMoneyData.saveAll();
        server_cache.clear();
    }

    public File file() {
        return new File(ROOT_PD, this.uuid.toString() + ".dat");
    }

    public void readFromFile() {
        File file = this.file();
        if (file.exists()) {
            try {
                NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
                this.readFromNBT(nbt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.disable();
            this.enable();
            this.writeToFile();
        }
    }

    public void writeToFile() {
        File file = this.file();
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected LOTRPlayerMoneyData(UUID uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public EntityPlayerMP player() {
        return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(this.name);
    }

    public final void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("money", this.money);
    }

    public final void readFromNBT(NBTTagCompound nbt) {
        this.money = nbt.func_74762_e("money");
    }

    static {
        LOTRPlayerMoneyData.setRoots();
        server_cache = Maps.newHashMap();
        client_cache = null;
    }
}

